#include "General.h"
#include "VeteranSystem.h"
#include "HashTemplateClass.h"
#include "HashTemplateIterator.h"
#include "ScriptableGameObj.h"
#include "DamageableGameObj.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"
#include "PhysicalGameObj.h"

#define SOLDIER_TIER_LOW 1
#define SOLDIER_TIER_MID 2
#define SOLDIER_TIER_HIGH 3

DynamicVectorClass<PromoteInfo*> PromotionNames;
HashTemplateClass<StringClass, PlayerVetInfo*> VetList;
HashTemplateClass<StringClass, int> SoldierTiers;

#define VETPAGECOLOUR "112,219,147"

char* WeaponList[17][2] =
{
	{ "Repair Gun(Weak)", "POW_RepairGun_Player" },
	{ "Remote C4", "CnC_POW_MineRemote_02" },
	{ "Chain Gun", "POW_Chaingun_Player" },
	{ "Rocket Launcher(Weak)", "POW_RocketLauncher_Player" },
	{ "Chemical Sprayer", "POW_ChemSprayer_Player" },
	{ "Tiberium Auto Rifle", "POW_TiberiumAutoRifle_Player" },
	{ "Sniper Rifle", "POW_SniperRifle_Player" },
	{ "Laser Chaingun",	"POW_LaserChaingun_Player" },
	{ "Laser Rifle", "POW_LaserRifle_Player" },
	{ "Rocket Launcher(Strong)", "CnC_POW_RocketLauncher_Player" },
	{ "Tiberium Flechette Gun",	"POW_TiberiumFlechetteGun_Player" },
	{ "Personal Ion Cannon", "POW_PersonalIonCannon_Player" },
	{ "Railgun", "POW_Railgun_Player" },
	{ "Ramjet Rifle", "POW_RamjetRifle_Player" },
	{ "Volt Auto Rifle", "POW_VoltAutoRifle_Player" },
	{ "Proximity Mines", "POW_MineProximity_Player" },
	{ "Timed C4", "CnC_POW_MineTimed_Player_02" },
};
const char* Get_Random_Weapon(int Number, int Type)
{
	return WeaponList[Number][Type];
}

char* GDICharacterList[10][2] =
{
	{ "Officer", "CnC_GDI_MiniGunner_1Off" },
	{ "Rocket Soldier",	"CnC_GDI_RocketSoldier_1Off" },
	{ "Sydney",	"CnC_Sydney" },
	{ "Deadeye", "CnC_GDI_MiniGunner_2SF" },
	{ "Gunner",	"CnC_GDI_RocketSoldier_2SF"	},
	{ "Patch", "CnC_GDI_Grenadier_2SF" },
	{ "Havoc", "CnC_GDI_MiniGunner_3Boss" },
	{ "Prototype Sydney", "CnC_Sydney_PowerSuit" },
	{ "Mobius",	"CnC_Ignatio_Mobius" },
	{ "Hotwire", "CnC_GDI_Engineer_2SF"	}
};
 
char* NodCharacterList[10][2] =
{
	{ "Officer", "CnC_Nod_Minigunner_1Off" },
	{ "Rocket Soldier",	"CnC_Nod_RocketSoldier_1Off" },
	{ "Chem Warrior", "CnC_Nod_FlameThrower_1Off" },
	{ "Blackhand Sniper", "CnC_Nod_Minigunner_2SF" },
	{ "Laser Chaingunner", "CnC_Nod_RocketSoldier_2SF" },
	{ "Stealth Black Hand",	"CnC_Nod_FlameThrower_2SF" },
	{ "Sakura",	"CnC_Nod_Minigunner_3Boss" },
	{ "Raveshaw", "CnC_Nod_RocketSoldier_3Boss"	},
	{ "Mendoza", "CnC_Nod_FlameThrower_3Boss" },
	{ "Technician",	"CnC_Nod_Technician_0" }
};

const char* Get_Random_Character(int Team, int Number, int Type)
{
	if (Team == 1)
	{
		return GDICharacterList[Number][Type];
	}
	else
	{
		return NodCharacterList[Number][Type];
	}
}

char* GDIVehicleList[6][2] =
{
	{ "GDI Humvee",	"CnC_GDI_Humm-vee"},
	{ "GDI APC", "CnC_GDI_APC"},
	{ "GDI MRLS", "CnC_GDI_MRLS"},
	{ "GDI Medium Tank", "CnC_GDI_Medium_Tank"},
	{ "GDI Mammoth Tank", "CnC_GDI_Mammoth_Tank"},
	{ "GDI Orca", "CnC_GDI_Orca"}
};
 
char* NodVehicleList[6][2] =
{
	{ "Nod Buggy", "CnC_Nod_Buggy"},
	{ "Nod APC", "CnC_Nod_APC"},
	{ "Nod Mobile Artillery", "CnC_Nod_Mobile_Artillery"},
	{ "Nod Flame Tank",	"CnC_Nod_Flame_Tank"},
	{ "Nod Stealth Tank", "CnC_Nod_Stealth_Tank"},
	{ "Nod Apache", "CnC_Nod_Apache"}
};

void Load_Soldier_Tiers(INIClass* SSGMIni)
{	
	int Count = SSGMIni->Entry_Count("VeteranSystem_Tiers");
	for (int i = 0; i < Count; i++)
	{
		const char *Entry = SSGMIni->Get_Entry("VeteranSystem_Tiers", i);
		int TierValue;
		TierValue = SSGMIni->Get_Int("VeteranSystem_Tiers", Entry, SOLDIER_TIER_LOW);
//		Console_Output("key = %s, value = %d\n", Entry, TierValue); // DEBUG CRAP
		SoldierTiers.Insert(Entry, TierValue);
	}
}
void Update_Vet_Points(PlayerVetInfo* VetInfo)
{
	if (VetInfo->DamageDone > 400.0f)
	{
		VetInfo->VetPoints += 1;
		VetInfo->DamageDone -= 400.0f;
//		Console("MSG Debug: DamageDone = %f", VetInfo->DamageDone);
	}
}

const char* Get_Random_Vehicle(int Team, int Number, int Type)
{
	if (Team == 1)
	{
		return GDIVehicleList[Number][Type];
	}
	else
	{
		return NodVehicleList[Number][Type];
	}
}

void Drop_Off(GameObject *Place, const char *Preset)
{	
	char Prams[270];
	sprintf(Prams, "%d,%s", Get_Player_ID(Place), Preset);

	Vector3 Location = Commands->Get_Position(Place);
	Location.Y += 5;

	GameObject *Drop = Commands->Create_Object("invisible_object", Location);
	Commands->Attach_Script(Drop,"Drop_Off_Control",Prams);
}

const PromoteInfo* Get_Promotion_Info(int Level)
{
	if (Level == 0)
	{
		return 0;
	}

	if(PromotionNames.Count() < Level)
	{
		return 0;
	}

	return PromotionNames[Level-1];
}

void Init_Vet_Info(const char* PlayerName)
{
	if (!VetList.Exists(PlayerName))
	{
		PlayerVetInfo* Temp = new PlayerVetInfo;
		memset((void*)Temp, 0, sizeof(PlayerVetInfo));
		
		Temp->VetLevel = 1;
//		Temp->VetPoints = 250; // DEBUG CRAP

		VetList.Insert(PlayerName, Temp);
	}
}

void Set_Max_Health_Only(GameObject *obj,float health)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	DamageableGameObj *o = ((ScriptableGameObj *)obj)->As_DamageableGameObj();
	if (!o)
	{
		return;
	}
	o->Get_Defense_Object()->Set_Health_Max(health);
}
 
void Set_Max_Shield_Strength_Only(GameObject *obj,float shieldstrength)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	DamageableGameObj *o = ((ScriptableGameObj *)obj)->As_DamageableGameObj();
	if (!o)
	{
		return;
	}
	o->Get_Defense_Object()->Set_Shield_Strength_Max(shieldstrength);
}

void Update_Player(int ID, GameObject *obj)
{
	const char* PlayerName = Get_Player_Name_By_ID(ID);

	PlayerVetInfo* VetInfo = VetList.Get(PlayerName, 0);
	if (!VetInfo) return;

	const PromoteInfo* Promote = Get_Promotion_Info(VetInfo->VetLevel);
	if (!Promote) return;

	Set_Max_Health_Only(obj, Commands->Get_Health(obj)*((Promote->Health / (float)100)+1)); 
	Set_Max_Shield_Strength_Only(obj, Commands->Get_Shield_Strength(obj)*((Promote->Armor / (float)100)+1));

	if(Promote->Regeneration > 0)
	{
		char tmp[64];
		sprintf(tmp, "10,1,%f", Promote->Regeneration);

		Attach_Script_Once(obj, "JFW_Health_Regen", tmp);
		Attach_Script_Once(obj, "JFW_Armour_Regen", tmp);
	}

	int Cost = Get_Cost(Commands->Get_Preset_Name(obj));

	if(Cost > 0 && Promote->Discount > 0.0f)
	{
		float Discount =  Cost * Promote->Discount;
		Find_Player(ID)->Increment_Money(Discount);

		if ( obj->As_VehicleGameObj())
		{
			const char* VehName = Get_Translated_Preset_Name(obj);
			Page(ID, "Your %s has been upgraded and you have been discounted %.0f for being a %s.", VehName, Discount, Promote->Name);
			delete []VehName;
		}
		else
		{
			Page(ID, "You have been discounted %.0f credits on your purchase for being a %s (level %d)", Discount, Promote->Name, VetInfo->VetLevel);
		}
	}
	delete []PlayerName;
}

void Check_Vet_Levels()
{
	int MaxVetLevel = PromotionNames.Count();
	for (int i = 1; i < (int)The_Game()->Get_Max_Players() + 1; i++)
	{
		cPlayer* player = Find_Player(i);

		if (!player) continue;

		const StringClass ClientName = player->Get_Name();
		PlayerVetInfo* VetInfo =  VetList.Get(ClientName, 0);

		if (VetInfo->VetLevel < MaxVetLevel)
		{
			const PromoteInfo* NextLevel = Get_Promotion_Info(VetInfo->VetLevel+1);
			if (NextLevel && (VetInfo->VetPoints >= NextLevel->Points)) // Promote
			{
//				Console("MSG Debug: VetLevel = %d", VetInfo->VetLevel); // DEBUG CRAP
				Console("MSG %S was promoted to %s!", player->Get_Name(), NextLevel->Name);
				Page(player->Get_Id(), "You have been promoted to %s. You get %.0f percent more health and %.0f percent armor and %.0f percent discount on all purchases.",
					NextLevel->Name, NextLevel->Armor, NextLevel->Health, (float)(NextLevel->Discount * 100));
				Console("icon %d p_hemedal.w3d", player->Get_Id());
				Console("icon2 %d p_hemedal.w3d", player->Get_Id());
				Console("sndp %d bonus_complete.wav", player->Get_Id());

				VetInfo->VetLevel = NextLevel->Level; 
			}
		}
	}
}

void Do_Vet_Points_Command(int PlayerID)
{
	const char* PlayerName = Get_Player_Name_By_ID(PlayerID);
	PlayerVetInfo* VetInfo = VetList.Get(PlayerName, 0);

	if (VetInfo)
	{
		if (VetInfo->VetPoints == 0)
		{
			Page(PlayerID, "You do not currently have any Veteran points. You can earn them by killing enemy soldiers, vehicles and buildings.");
		}
		const PromoteInfo* CurrentLevel = Get_Promotion_Info(VetInfo->VetLevel);
		const PromoteInfo* NextLevel = Get_Promotion_Info(VetInfo->VetLevel+1);

		if (VetInfo->VetPoints > 0 && CurrentLevel && NextLevel)
		{
			Page(PlayerID, "You are a %s with %d Veteran point(s), you need %d more Veteran point(s) to reach %s.",
				CurrentLevel->Name, VetInfo->VetPoints, NextLevel->Points - VetInfo->VetPoints, NextLevel->Name);
		}
	}
	delete []PlayerName;
}
void Do_Character_Command(int PlayerID)
{
	const char* PlayerName = Get_Player_Name_By_ID(PlayerID);
	PlayerVetInfo* VetInfo = VetList.Get(PlayerName, 0);

	if (VetInfo)
	{
		if (VetInfo->VetLevel < 4)
		{
			Page(PlayerID, "You must be Elite (level 4) to use the !character veteran command.");
		}
		else if (((int)time(NULL) - (int)VetInfo->VetCharacter) < 300)
		{
			Page(PlayerID, "You need to wait %d second before you can use the !character veteran command again.", 300 - ((int)time(NULL) - (int)VetInfo->VetCharacter));
		}
		else
		{
			int Random = Commands->Get_Random_Int(1,10);

			Change_Character(Get_GameObj(PlayerID), Get_Random_Character(Get_Team(PlayerID),Random,1));
			Page(PlayerID,"You have been transformed into a %s by the !character veteran command.",Get_Random_Character(Get_Team(PlayerID),Random,0));
		
			VetInfo->VetCharacter = time(NULL);
		}
	}
	delete []PlayerName;
}

void Do_Weapon_Command(int PlayerID)
{
	const char* PlayerName = Get_Player_Name_By_ID(PlayerID);
	PlayerVetInfo* VetInfo = VetList.Get(PlayerName, 0);

	if (VetInfo)
	{
		if (VetInfo->VetLevel < 3)
		{
			Page(PlayerID, "You must be Elite (level 3) to use the !weapon veteran command.");
		}
		else if (((int)time(NULL) - (int)VetInfo->VetWeapon) < 300)
		{
			Page(PlayerID, "You need to wait %d second before you can use the !weapon veteran command again.", 300 - ((int)time(NULL) - (int)VetInfo->VetWeapon));
		}
		else
		{
			int Random = Commands->Get_Random_Int(1,16);

			Grant_Powerup(Get_GameObj(PlayerID), Get_Random_Weapon(Random, 1));
			Page(PlayerID, "You have received a %s from the !weapon veteran command.",  Get_Random_Weapon(Random, 1));
		
			VetInfo->VetWeapon = time(NULL);
		}
	}
	delete []PlayerName;
}

void Do_Vehicle_Command(int PlayerID)
{
	const char* PlayerName = Get_Player_Name_By_ID(PlayerID);
	PlayerVetInfo* VetInfo = VetList.Get(PlayerName, 0);

	if (VetInfo)
	{
		if (VetInfo->VetLevel < 5)
		{
			Page(PlayerID, "You must be Elite (level 5) to use the !vehicle veteran command.");
		}
		else if (((int)time(NULL) - (int)VetInfo->VetVehicle) < 300)
		{
			Page(PlayerID, "You need to wait %d second before you can use the !vehicle veteran command again.", 300 - ((int)time(NULL) - (int)VetInfo->VetVehicle));
		}
		else
		{
			int Random = Commands->Get_Random_Int(1, 5);

			Drop_Off(Get_GameObj(PlayerID), Get_Random_Vehicle(Get_Team(PlayerID), Random, 1));
			Page(PlayerID, "You have received a %s from the !vehicle veteran command.", Get_Random_Vehicle(Get_Team(PlayerID), Random, 1));
		
			VetInfo->VetVehicle = time(NULL);
		}
	}
	delete []PlayerName;
}

void Page(int ID, const char *Format, ...)
{
	if(ID < 1 || ID > 128)
	{
		return;
	}

	if (!Get_GameObj(ID))
	{
		return;
	}

	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	float Version = Get_Client_Version(ID);

	if(Version < 2.9)
	{
		Console("ppage %d %s", ID, buffer);
		return;
	}
	else
	{
		Console("cmsgp %d %s %s", ID, VETPAGECOLOUR, buffer);
	}
/*
	if(Settings::EnablePageSound)
	{
		Console("sndp %d %s", ID, Settings::PageSoundFile);
	} */
} 

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

void Load_Promotion_Info()
{
	/* testing some hard-coded stuff */

	PromoteInfo* Promote = new PromoteInfo;
	Promote->Armor = 0;
	Promote->Health = 0;
	Promote->Regeneration = 0;
	Promote->Discount = 0.0f;
	Promote->Points = 0;
	Promote->Level = 1;
	Promote->Name = "Recruit";

	PromotionNames.Add(Promote);

	PromoteInfo* Promote2 = new PromoteInfo;
	Promote2->Armor = 10;
	Promote2->Health = 10;
	Promote2->Regeneration = 0.0f;
	Promote2->Discount = .10f;
	Promote2->Points = 30;
	Promote2->Level = 2;
	Promote2->Name = "Soldier";

	PromotionNames.Add(Promote2);

	PromoteInfo* Promote3 = new PromoteInfo;
	Promote3->Armor = 15;
	Promote3->Health = 15;
	Promote3->Regeneration = 0.0f;
	Promote3->Discount = .15f;
	Promote3->Points = 60;
	Promote3->Level = 3;
	Promote3->Name = "Commando";

	PromotionNames.Add(Promote3);

	PromoteInfo* Promote4 = new PromoteInfo;
	Promote4->Armor = 15;
	Promote4->Health = 15;
	Promote4->Regeneration = 5.0f;
	Promote4->Discount = .20f;
	Promote4->Points = 100;
	Promote4->Level = 4;
	Promote4->Name = "Veteran";

	PromotionNames.Add(Promote4);

	PromoteInfo* Promote5 = new PromoteInfo;
	Promote5->Armor = 25;
	Promote5->Health = 25;
	Promote5->Regeneration = 10.0f;
	Promote5->Discount = .40f;
	Promote5->Points = 150;
	Promote5->Level = 5;
	Promote5->Name = "Elite";

	PromotionNames.Add(Promote5);

	PromoteInfo* Promote6 = new PromoteInfo;
	Promote6->Armor = 30;
	Promote6->Health = 30;
	Promote6->Regeneration = 15.0f;
	Promote6->Discount = .50f;
	Promote6->Points = 200;
	Promote6->Level = 6;
	Promote6->Name = "Legend";

	PromotionNames.Add(Promote6);

//	const PromoteInfo* test = Get_Promotion_Info(1); // DEBUG CRAP
//	const PromoteInfo* test2 = Get_Promotion_Info(2); // DEBUG CRAP
}

VeteranSystem::VeteranSystem()
{
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_CHAT_HOOK,this);
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	RegisterEvent(EVENT_GAME_OVER_HOOK,this);
	RegisterEvent(EVENT_PLAYER_JOIN_HOOK,this);

	Load_Promotion_Info();
}

VeteranSystem::~VeteranSystem()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_CHAT_HOOK,this);
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	UnregisterEvent(EVENT_GAME_OVER_HOOK,this);
	UnregisterEvent(EVENT_PLAYER_JOIN_HOOK,this);
}


bool VeteranSystem::OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
{
	if (Message[0] == L'!')
	{
		if ((wcsistr(Message,L"!vp") == Message) ||
			(wcsistr(Message,L"!vp") == Message))
		{
			Do_Vet_Points_Command(PlayerID);
		}
		else if ((wcsistr(Message,L"!character") == Message) ||
			(wcsistr(Message,L"!char") == Message))
		{
			Do_Character_Command(PlayerID);
		}
		else if ((wcsistr(Message,L"!weapon") == Message) ||
			(wcsistr(Message,L"!weap") == Message))
		{
			Do_Weapon_Command(PlayerID);
		}
		else if ((wcsistr(Message,L"!vehicle") == Message) ||
			(wcsistr(Message,L"!veh") == Message))
		{
			Do_Vehicle_Command(PlayerID);
		}
	}
	return true;
}

void VeteranSystem::OnLoadGlobalINISettings(INIClass *SSGMIni)
{
	Load_Soldier_Tiers(SSGMIni);
}

void VeteranSystem::OnObjectCreate(void *data,GameObject *obj)
{
	if (Commands->Is_A_Star(obj) && obj->As_SoldierGameObj() )
	{
		Attach_Script_Once(obj, "Veteran_Player", "");
		Update_Player(Get_Player_ID(obj), obj);
	}
	else if (obj->As_VehicleGameObj() )
	{
		Attach_Script_Once(obj, "Veteran_Vehicle", "");
	}
	else if (obj->As_PhysicalGameObj() && obj->As_PhysicalGameObj()->As_C4GameObj() )
	{
		Attach_Script_Once(obj, "Veteran_C4", "");
	}
	else if (obj->As_PhysicalGameObj() && obj->As_PhysicalGameObj()->As_BeaconGameObj() )
	{
		Attach_Script_Once(obj, "Veteran_Beacon", "");
	}
	else if (obj->As_BuildingGameObj() )
	{
		Attach_Script_Once(obj, "Veteran_Building", "");
	}
}

void VeteranSystem::OnLoadLevel()
{
	/* delete the VetList here and then reinsert empty info for every player currently in-game */
		for (HashTemplateIterator<StringClass, PlayerVetInfo*> iter(VetList); iter; ++iter)
	{
		Console_Output("name = %s, vet points = %d\n", iter.getKey(), iter.getValue()->VetLevel);
		delete iter.getValue();
	}
	VetList.Remove_All();

	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *player = PlayerIter->Data();
		const StringClass ClientName = player->Get_Name();
		Init_Vet_Info(ClientName);
	}

	GameObject* obj = Commands->Create_Object("Invisible_Object", Vector3(0.0f,0.0f,0.0f));
	Attach_Script_Once(obj,"Veteran_Think","");
}

void VeteranSystem::OnGameOver()
{
}

void VeteranSystem::OnPlayerJoin(int PlayerID,const char *PlayerName)
{
	Init_Vet_Info(PlayerName);
}

void Drop_Off_Control::Created(GameObject *obj)
{
	//SignalFlare_Gold_Phys3
	int ID = Get_Int_Parameter("ID");
	const char *Preset = Get_Parameter("Preset");
	int Team = Get_Team(ID);
	Vector3 pos = Commands->Get_Position(obj);
	
	GameObject *transbone = Commands->Create_Object("Generic_Cinematic", pos);
	Commands->Set_Model(transbone, "XG_TransprtBone");
	Commands->Set_Animation(transbone, "XG_TransprtBone.XG_HD_TTraj", false, "", 2.0, -1.0, false);

	GameObject *trans = Commands->Create_Object_At_Bone(transbone, Team == 1 ? "CnC_GDI_Transport" : "CnC_Nod_Transport", "BN_Trajectory");

	Commands->Set_Animation(trans, "v_GDI_trnspt.XG_HD_Transport", false, "", 2.0, -1.0, false);
	//Fix_due_4.1_scripts Set_Vehicle_Is_Visible(trans, false);
	Commands->Set_Is_Visible(trans, false);
	Commands->Set_Shield_Type(trans,"Blamo");
	Commands->Attach_To_Object_Bone(trans, transbone, "BN_Trajectory");
 
	GameObject *vehharness = Commands->Create_Object("Generic_Cinematic", pos);
	Commands->Set_Model(vehharness, "XG_HD_HTraj");
	Commands->Set_Animation(vehharness, "XG_HD_HTraj.XG_HD_HTraj", false, "", 2.0, -1.0, false);
 
	GameObject *fakeharness = Commands->Create_Object("Generic_Cinematic", pos);
	Commands->Set_Model(fakeharness, "XG_HD_Harness");
	Commands->Set_Animation(fakeharness, "XG_HD_Harness.XG_HD_Harness", false, "", 2.0, -1.0, false);
 
	GameObject *vehicle = Commands->Create_Object_At_Bone(vehharness, Preset, "BN_Trajectory");
	Set_Object_Type(vehicle, Team);
	//Fix_due_4.1_scripts Set_Vehicle_Is_Visible(vehicle, false);
	Commands->Set_Is_Visible(trans, false);
	Commands->Attach_To_Object_Bone(vehicle, vehharness, "BN_Trajectory");
 
	transbone_id = Commands->Get_ID(transbone);
	trans_id = Commands->Get_ID(trans);
	vehharness_id = Commands->Get_ID(vehharness);
	vehicle_id = Commands->Get_ID(vehicle);
	fakeharness_id = Commands->Get_ID(fakeharness);
 
	Commands->Start_Timer(obj, this, 14.2f, 1);
	Commands->Start_Timer(obj, this, 30, 2);
}

void Drop_Off_Control::Timer_Expired(GameObject *obj, int number)
{
	if(number == 1)
	{
		GameObject *VehiclePreset = Commands->Find_Object(vehicle_id);
		if(VehiclePreset)
		{
			Commands->Attach_To_Object_Bone(Commands->Find_Object(vehicle_id), 0, 0);
		}
	}
	else if(number == 2)
	{
		GameObject *TransbonePreset = Commands->Find_Object(transbone_id);

		if(TransbonePreset) Commands->Destroy_Object(TransbonePreset);

		GameObject *HarnessPreset = Commands->Find_Object(vehharness_id);

		if(HarnessPreset) Commands->Destroy_Object(HarnessPreset);

		GameObject *FakeHarnessPreset = Commands->Find_Object(fakeharness_id);

		if(FakeHarnessPreset) Commands->Destroy_Object(FakeHarnessPreset);

		GameObject *TransportPreset = Commands->Find_Object(trans_id);

		if(TransportPreset) Commands->Destroy_Object(TransportPreset);

		Destroy_Script();
	}
} 

void Veteran_Vehicle::Created(GameObject *obj)
{
	Commands->Start_Timer(obj,this,1,1);
}
void Veteran_Vehicle::Damaged(GameObject *obj, GameObject *attacker, float damage)
{
	if (!Commands->Is_A_Star(attacker)) return;
	if (obj == attacker) return;

	int TeamVictim = Commands->Get_Player_Type(obj);
	if ((TeamVictim != 1) && (TeamVictim != 0)) return;

	int TeamAttacker = Commands->Get_Player_Type(attacker);

	const char* PlayerName = Get_Player_Name(attacker);
	PlayerVetInfo* VetInfo = VetList.Get(PlayerName, 0);
	delete []PlayerName;

	if (!VetInfo) return;

	if ((TeamVictim == TeamAttacker) && (damage < 0.0f))
	{
//		Console("MSG Debug: Triggered with %f damage, %f DamageDone", damage, VetInfo->DamageDone);
		VetInfo->DamageDone += -damage;
	}
	else if ((TeamVictim != TeamAttacker) && (damage > 0.0f))
	{
		VetInfo->DamageDone += damage;
	}
	Update_Vet_Points(VetInfo);
}

void Veteran_Vehicle::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{		
		GameObject *sender = Get_Vehicle_Owner(obj);
		if (!sender) return;

		const char* PlayerName = Get_Player_Name(sender);
		PlayerVetInfo* VetInfo = VetList.Get(PlayerName, 0);
		if (!VetInfo) return;
 
		const char *VehicleName = Get_Translated_Preset_Name(obj);
			
		if(VetInfo->VetLevel > 1)
		{
			Update_Player(Get_Player_ID(sender), obj);
		}
		delete []PlayerName; 
		delete []VehicleName;
	}
}

void Veteran_Player::Created(GameObject *obj)
{
// Don't use this, it gets called twice.
//	Update_Player(Get_Player_ID(obj), obj);

}

void Veteran_Player::Damaged(GameObject *obj, GameObject *attacker, float damage)
{
}

void Veteran_Player::Killed(GameObject *obj, GameObject *killer)
{
	if (!Commands->Is_A_Star(killer)) return;

	const char* PlayerName = Get_Player_Name(killer);
	PlayerVetInfo* VetInfo = VetList.Get(PlayerName, 0);
	delete []PlayerName;

	if (VetInfo)
	{
		int SoldierTier = SoldierTiers.Get(Commands->Get_Preset_Name(obj), SOLDIER_TIER_LOW);
		VetInfo->VetPoints += SoldierTier;
//		Console("MSG Debug: Vet points = %d", VetInfo->VetPoints); // DEBUG CRAP
	}		
}

void Veteran_Think::Created(GameObject *obj)
{
	Commands->Start_Timer(obj, this, 30.0f, 1);
}
 
void Veteran_Think::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{		
		Check_Vet_Levels();
		Commands->Start_Timer(obj, this, 30.0f, 1);
	}
}

void Veteran_C4::Killed(GameObject *obj, GameObject *killer)
{
	if (!Commands->Is_A_Star(killer)) return;
	
	const char* PlayerName = Get_Player_Name(killer);
	PlayerVetInfo* VetInfo = VetList.Get(PlayerName, 0);
	delete []PlayerName;

	if (VetInfo)
	{
		VetInfo->VetPoints += 1;
	}
}

void Veteran_Beacon::Killed(GameObject *obj, GameObject *killer)
{
	if (!Commands->Is_A_Star(killer)) return;
	
	const char* PlayerName = Get_Player_Name(killer);
	PlayerVetInfo* VetInfo = VetList.Get(PlayerName, 0);
	delete []PlayerName;

	if (VetInfo)
	{
		VetInfo->VetPoints += 3;
//		Console("MSG Debug: Vet points = %d", VetInfo->VetPoints); // DEBUG CRAP
	}
}

void Veteran_Building::Damaged(GameObject *obj, GameObject *attacker, float damage)
{
	if (!Commands->Is_A_Star(attacker)) return;

	int TeamVictim = Commands->Get_Player_Type(obj);
	int TeamAttacker = Commands->Get_Player_Type(attacker);

	const char* PlayerName = Get_Player_Name(attacker);
	PlayerVetInfo* VetInfo = VetList.Get(PlayerName, 0);
	delete []PlayerName;

	if (!VetInfo) return;

	if ((TeamVictim == TeamAttacker) && (damage < 0.0f))
	{
//		Console("MSG Debug: Triggered with %f damage, %f DamageDone", damage, VetInfo->DamageDone);
		VetInfo->DamageDone += -(damage * 2.f);
	}
	else if ((TeamVictim != TeamAttacker) && (damage > 0.0f))
	{
		VetInfo->DamageDone += damage * 2.f;
	}
	Update_Vet_Points(VetInfo);
}

void Veteran_Building::Killed(GameObject *obj, GameObject *killer)
{
	if (!Commands->Is_A_Star(killer)) return;

	int TeamVictim = Commands->Get_Player_Type(obj);
	int TeamAttacker = Commands->Get_Player_Type(killer);

	const char* PlayerName = Get_Player_Name(killer);
	PlayerVetInfo* VetInfo = VetList.Get(PlayerName, 0);
	delete []PlayerName;

	if (!VetInfo) return;

	if (TeamVictim != TeamAttacker)
	{
		VetInfo->VetPoints += 20;
	}
}

VeteranSystem veteranSystem;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &veteranSystem;
}

ScriptRegistrant<Drop_Off_Control> DropOffControlRegistrant("Drop_Off_Control", "ID:int,Preset:string");
ScriptRegistrant<Veteran_Vehicle> Veteran_Vehicle_Registrant("Veteran_Vehicle", "");
ScriptRegistrant<Veteran_Player> Veteran_Player_Registrant("Veteran_Player", "");
ScriptRegistrant<Veteran_Think> Veteran_Think_Registrant("Veteran_Think", "");
ScriptRegistrant<Veteran_C4> Veteran_C4_Registrant("Veteran_C4", "");
ScriptRegistrant<Veteran_Beacon> Veteran_Beacon_Registrant("Veteran_Beacon", "");
ScriptRegistrant<Veteran_Building> Veteran_Building_Registrant("Veteran_Building", "");